/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IM_GMP_H__
#define __IM_GMP_H__

#ifdef __cplusplus
   extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>

typedef struct _pat_file_header {
   guint32  headersize; // Size of pattern header + name pattern
   guint32  version;    // Version of pattern
   guint32  width;      // Width of pattern
   guint32  height;     // Height of pattern
   guint32  depth;      // Colour depth
   guint32  magicnumber;// GIMP pattern magic number.
} pat_info  ;

typedef struct _gbr_file_header {
   guint32  headersize; // Size of pattern header + name pattern
   guint32  version;    // Version of pattern
   guint32  width;      // Width of pattern
   guint32  height;     // Height of pattern
   guint32  depth;      // Colour depth
   guint32  magicnumber;// GIMP pattern magic number.
   guint32  spacing    ;
} gbr_info  ;

typedef  gboolean (*GmpLoadFunc) (guint* buffer, guchar *cmap[], gint transparent, gint width, gint scanline, gint frame);

gboolean gmp_load                (gchar *filename, GmpLoadFunc func);

gboolean pat_get_header          (gchar *filename, pat_info   *info);
gboolean gbr_get_header          (gchar *filename, gbr_info   *info);

#ifdef __cplusplus
   }
#endif /* __cplusplus */

#endif

