# -*- coding: utf-8 -*-

import gobject
import gtk
import os

class ImportUtf:
	def __init__(self, mainwin):
		self.mainwin = mainwin

	def import_utffile(self, filename):
		self.mainwin.enable_network = False
		self.mainwin.char_liststore = gtk.ListStore(gobject.TYPE_STRING, object, gobject.TYPE_BOOLEAN)
		content = unicode(file(filename).read(), "UTF-8")
		for uc in content:
			if uc != u'\n':
				utf8char = uc.encode("UTF-8")
				self.mainwin.char_liststore.append([utf8char, [], False])

	def do_import(self):
		dialog = gtk.FileChooserDialog ("Select utf file", 
				self.mainwin, 
				gtk.FILE_CHOOSER_ACTION_OPEN,
				(gtk.STOCK_OPEN, gtk.RESPONSE_OK,
				 gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		utffilter = gtk.FileFilter()
		utffilter.set_name("UTF-8 utf file")
		utffilter.add_pattern("*.utf*")
		allfilter = gtk.FileFilter()
		allfilter.set_name("Any file")
		allfilter.add_pattern("*")
		dialog.add_filter(utffilter)
		dialog.add_filter(allfilter)
		dialog.set_default_response (gtk.RESPONSE_OK)
		dialog.set_position (gtk.WIN_POS_CENTER_ON_PARENT)
		dialog.set_current_folder(os.getenv("PWD") + "/data");
		retval = dialog.run ()
		if retval == gtk.RESPONSE_OK:
			self.import_utffile(dialog.get_filename())
		dialog.destroy ()
		
