CREATE TABLE user_tbl (
	id INT UNSIGNED AUTO_INCREMENT,
	name CHAR(16) NOT NULL,
	passwd CHAR(32) BINARY NOT NULL,
	lasttime INT UNSIGNED NOT NULL,

	PRIMARY KEY(id),
	UNIQUE INDEX(name)
);

CREATE TABLE user_basic (
	id INT UNSIGNED NOT NULL,
	auth TINYINT UNSIGNED NOT NULL,
	nick CHAR(16) NOT NULL,
	email CHAR(32) NOT NULL,
	gender TINYINT UNSIGNED NOT NULL,
	birth INT UNSIGNED NOT NULL,

	PRIMARY KEY(id),
	INDEX(nick),
	INDEX(email)
);

CREATE TABLE user_ext (
	id INT UNSIGNED NOT NULL,
	country VARCHAR(32) NOT NULL,
	city VARCHAR(64) NOT NULL,
	address VARCHAR(64) NOT NULL,
	postcode VARCHAR(16) NOT NULL,
	tel VARCHAR(32) NOT NULL,
	mobile VARCHAR(32) NOT NULL,
	realname VARCHAR(48) NOT NULL,
	occupation VARCHAR(16) NOT NULL,
	homepage VARCHAR(64) NOT NULL,
	intro TINYTEXT NOT NULL,

	PRIMARY KEY(id)
);

CREATE TABLE roster (
	id INT UNSIGNED NOT NULL,
	contact VARCHAR(80) NOT NULL,
	subscrpt TINYINT NOT NULL,

	INDEX(id),
	UNIQUE INDEX(id, contact)
);

CREATE TABLE message (
	id INT UNSIGNED NOT NULL,
	src VARCHAR(80) NOT NULL,
	time INT UNSIGNED NOT NULL,
	type TINYINT UNSIGNED NOT NULL,
	text TINYTEXT NOT NULL,

	INDEX(id)
);
