/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright            : (C) 2003 by Zhang Yong                         *
 *   email                : z-yong163@163.com                              *
 ***************************************************************************/

#ifndef _ICQ_MAIN_H
#define _ICQ_MAIN_H

#include "udpsession.h"
#include "tcpsession.h"
#include "proxy.h"
#include <list>

using namespace std;

class SocketRegistry;


class ICQMain : public UDPSessionListener {
public:
	ICQMain(SocketRegistry *reg);
	virtual ~ICQMain();

	virtual const char *getUserName() = 0;
	virtual TCPSessionListener *getSessionListener(const char *type, TCPSessionBase *session);
	virtual bool getContactInfo(ONLINE_INFO &info) = 0;

	virtual void onRecvMessage(uint8 type, const char *from, time_t when, const char *text);


	UDPSession *getUDPSession() { return udpSession; }

	void setProxy(PROXY_INFO *proxy);
	void connect(const char *host, uint16 port);
	TCPSession *acceptSession(const char *type, Socket *sock);
	void removeSession(TCPSession *s);

	void login(const char *name, const char *passwd, const char *token, uint16 sequence, uint32 status);
	void logout();
	uint32 sendMessage(const char *to, const char *text);
	void sendTCPRequest(const char *type, const char *to, const char *nick, const char *reason);
	void acceptTCPRequest(const char *type, const char *to, uint16 port);

private:
	TCPSession *findSession(const char *type, const char *name);
	uint16 createListenSession(const char *type);
	TCPSession *createTCPSession(const char *type, const char *to, uint16 port, bool isSend);
	void destroyAllSessions();

	UDPSession *udpSession;
	list<TCPSession *> tcpSessionList;
	PROXY_INFO *proxyInfo;
};


#endif
