#ifndef __LINQ_MAIN_WIN_H__
#define __LINQ_MAIN_WIN_H__

#include "icqtypes.h"
#include "MainWin_ContactView.h"
#include "MainWin_ServiceView.h"
#include "MainWin_MobileView.h"
#include "MainWin_ChainView.h"

#include <gtk/gtk.h>

const int STATUS_ANIMATE_TIMOUT_INTERVAL = 500;

class MainWin{
public:
	MainWin();
	~MainWin();

	GtkWidget *window;

	void Show();
	void Hide();

	void changeStatus(uint32 status);
	void getInfo(const gchar *name);
	void doLogin();

	void onConnect(bool connected);
	gboolean onPreLoginReply(uint16 sequence, const char *token);
	void onLoginReply(uint8 error);
	void onContactListReply(const char *result[], int n);
	void onUserOnline(const gchar *name);
	void onUserOffline(const gchar *name);
	void onUserStatus(const char *name, uint32 status);
	void onAddContactReply(const char *name, uint8 auth);
	void onRecvMessage(uint8 type, const char *from, time_t when, const char *text);
	void onContactInfoReply(CONTACT_INFO &c);
	void onUserInfoReply(USER_INFO &user);
private:
	ContactView contact_view;
	ServiceView service_view;
	MobileView mobile_view;
	ChainView chain_view;

	GtkWidget *main_menu;
	GtkWidget *status_menu;
	GtkWidget *status_image;
	GtkWidget *status_label;

	gint status_animate_timeout;
	static gboolean status_animate_cb(gpointer data);

	static gboolean on_delete_event(GtkWidget * window, GdkEvent *event , MainWin *oMainWin);
	static gboolean on_key_press_release_event(GtkWidget * window, GdkEventKey *event , MainWin *oMainWin);
	
	static void on_chatroom_button_clicked(GtkWidget *button, MainWin *oMainWin);
	static void on_search_button_clicked(GtkWidget *button, MainWin *oMainWin);
	static void on_mozilla_button_clicked(GtkWidget *button, MainWin *oMainWin);
	static void on_message_button_clicked(GtkWidget *button, MainWin *oMainWin);
	static void on_menu_button_clicked(GtkWidget *button, MainWin *oMainWin);
	static void on_status_button_clicked(GtkWidget *button, MainWin *oMainWin);
	
	static void on_main_menu_netbookmark_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_gourpfriend_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_msghistory_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_memorandum_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_mobilemsg_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_changeskin_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_changeuser_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_regwizard_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_myoption_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_sysoption_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_help_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_main_menu_quit_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	
	static void on_status_menu_online_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_status_menu_away_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_status_menu_invis_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
	static void on_status_menu_offline_activate(GtkMenuItem *menuitem, MainWin *oMainWin);
};

#endif
