#ifndef __LINQ_REGWIZARD_H__
#define __LINQ_REGWIZARD_H__

#include "LinqWindow.h"
#include "LinqOption.h"
#include "udpsession.h"
#include <gtk/gtk.h>

class RegWizard : public LinqWindow
{
public:	
	RegWizard();
	~RegWizard();
	void Show(const gchar *user, const gchar *passwd);

	void onConnect(bool connected);
	void onRegisterReply(uint8 error);
	gboolean onPreLoginReply(uint16 sequence, const char *token);
	void onLoginReply(uint8 error);
	void onUserInfoReply(USER_INFO &user);
	void onContactListReply(const char *result[], int n);

private:
	gboolean waiting_preLogin;
	gboolean UserInfo_received;
	gboolean ContactList_received;

	enum RegPage {
		NB_CHOOSE,
		NB_BASIC_INFO,
		NB_CONTACT_INFO,
		NB_DETAIL_INFO,
		NB_NETWORK_INFO,
		NB_REGISTER_RESULT,
		NB_NUM,
		NB_NULL,
	};

	RegPage nb_current_page;

	GtkWidget *window;
	GtkWidget *back_button;
	GtkWidget *next_button;
	GtkWidget *cancel_button;

	static gboolean on_delete_event(GtkWidget * window, GdkEvent *event , RegWizard *oRegWizard);
	static void on_back_clicked(GtkWidget *button, RegWizard *oRegWizard);
	static void on_next_clicked(GtkWidget *button, RegWizard *oRegWizard);
	static void on_finish_clicked(GtkWidget *button, RegWizard *oRegWizard);
	static void on_cancel_clicked(GtkWidget *button, RegWizard *oRegWizard);
	
	void setFinished();
	
	void getInfo(USER_INFO &info);
	void getOption(LinqOption &option);
	
	GtkWidget *notebook;

	GtkWidget *nb_choose_new_user_radio;
	GtkWidget *nb_choose_exist_user_table;
	GtkWidget *nb_choose_user_entry;
	GtkWidget *nb_choose_password_entry;

	static void on_nb_choose_exist_user_radio_toggled(GtkToggleButton *button, RegWizard *oRegWizard);
	static void on_nb_choose_user_entry_activate(GtkEntry *entry, RegWizard *oRegWizard);
	static void on_nb_choose_password_entry_activate(GtkEntry *entry, RegWizard *oRegWizard);

	GtkWidget *nb_network_server_host_combo;
	GtkWidget *nb_network_server_port_entry;
	GtkWidget *nb_network_proxy_type_optionmenu;
	GtkWidget *nb_network_proxy_table;
	GtkWidget *nb_network_proxy_host_entry;
	GtkWidget *nb_network_proxy_port_entry;
	GtkWidget *nb_network_proxy_name_entry;
	GtkWidget *nb_network_proxy_passwd_entry;
	GtkWidget *nb_network_proxy_resolve_ckbutton;
	
	static void on_nb_network_proxy_type_optionmenu_changed(GtkOptionMenu *option_menu, RegWizard *oRegWizard);
	
	
	GtkWidget *nb_basic_account_entry;
	GtkWidget *nb_basic_passwd_1_entry;
	GtkWidget *nb_basic_passwd_2_entry;
	GtkWidget *nb_basic_nickname_entry;
	GtkWidget *nb_basic_gender_optionmenu;
	GtkWidget *nb_basic_birth_year_entry;
	GtkWidget *nb_basic_birth_month_entry;
	GtkWidget *nb_basic_birth_date_entry;
	GtkWidget *nb_basic_country_entry;
	GtkWidget *nb_basic_city_entry;
	
	
	GtkWidget *nb_contact_email_entry;
	GtkWidget *nb_contact_address_entry;
	GtkWidget *nb_contact_postcode_entry;
	GtkWidget *nb_contact_tel_entry;
	GtkWidget *nb_contact_mobile_entry;
	
	GtkWidget *nb_detail_realname_entry;
	GtkWidget *nb_detail_occupation_combo;
	GtkWidget *nb_detail_homepage_entry;
	GtkWidget *nb_detail_intro_textview;
	GtkWidget *nb_detail_auth_radio_1, *nb_detail_auth_radio_2;
	
	
	GtkWidget *nb_register_result_label;

	void create_nb_choose(const gchar *user, const gchar *passwd);
	void create_nb_basic_info();
	void create_nb_contact_info();
	void create_nb_detail_info();
	void create_nb_network_info();
	void create_nb_register_result();
	
	RegPage nb_choose_next();
	RegPage nb_basic_info_next();
	RegPage nb_contact_info_next();
	RegPage nb_detail_info_next();
	RegPage nb_network_info_next();
	RegPage nb_register_result_next();
};

#endif
