#ifndef __LINQ_SEARCH_DLG_H__
#define __LINQ_SEARCH_DLG_H__

#include "LinqWindow.h"
#include "icqmain.h"

#include <gtk/gtk.h>

struct LinqSearchResult {
	LinqSearchResult(SEARCH_RESULT &result);
	
	std::string name;
	uint32 status;
	std::string nick;
	uint8 auth;
	uint8 gender;
	uint8 age;
};

class SearchDlg : public LinqWindow
{
public:
	SearchDlg();
	~SearchDlg();
	void Show();

	void onSearchResult(SEARCH_RESULT result[], int n);
	gboolean onAddContactReply(const char *name, uint8 auth);
private:
	enum SearchPage {
		NB_CHOOSE,
		NB_CUSTOM_SEARCH,
		NB_USER_LIST,
		NB_ADD_FRIEND,
		NB_SERVER_LIST,
		NB_GROUP_TYPE_LIST,
		NB_GROUP_LIST,
		NB_GROUP_NUM,
		NB_CREATE_GROUP,
		NB_CREATE_GROUP_RESULT,
		NB_NUM,
		NB_NULL,
	};	
	enum ChooseRadio {
		NB_CHOOSE_RADIO_RANDOM_SEARCH,
		NB_CHOOSE_RADIO_CUSTOM_SEARCH,
		NB_CHOOSE_RADIO_REMOTE_FRIEND,
		NB_CHOOSE_RADIO_GROUP_LIST,
		NB_CHOOSE_RADIO_GROUP_NUM,
		NB_CHOOSE_RADIO_CREATE_GROUP,
	};

	SearchPage nb_current_page;
	ChooseRadio nb_choose_radio;
	
	std::list< std::list< LinqSearchResult > * > searchUserResultPageList;
	void clean_search_user_result();
	void refresh_search_user_result (gint refresh_page);
	gint search_user_result_current_page;

	
	GtkWidget *window;
	GtkWidget *notebook;
	GtkWidget *back_button;
	GtkWidget *next_button;
	GtkWidget *cancel_button;
	
	GtkWidget *radio_online_user, *radio_custom_search, *radio_remote_friend,
			  *radio_group_list, *radio_group_num, *radio_create_group;
	GtkWidget *search_custom_name_entry, *search_custom_nick_entry, *search_custom_email_entry;
	GtkWidget *group_num_entry;
	GtkWidget *create_group_name_entry, *create_group_password_entry;
	GtkWidget *create_group_result_info_label;
	GtkWidget *add_friend_image, *add_friend_uin_label, *add_friend_nick_label, *add_friend_info_label, *add_friend_hbox,
			  *add_friend_textview;
	GtkWidget *user_list_treeview, *user_list_info_label, *user_list_previous_button, *user_list_next_button,
			  *user_list_detail_button, *user_list_all_button;
	GtkWidget *server_list_treeview, *server_list_label;
	GtkWidget *group_type_list_treeview;
	GtkWidget *group_list_treeview, *group_list_info_label, *group_list_password_entry;

	void create_notebook();
	
	void create_nb_choose();
	void create_nb_customSearch();
	void create_nb_groupNUm();
	void create_nb_createGroup();
	void create_nb_createGroupResult();
	void create_nb_addFriend();
	void create_nb_userList();
	void create_nb_serverList();
	void create_nb_groupTypeList();
	void create_nb_groupList();
		
	SearchPage nb_user_list_next();
	SearchPage nb_server_list_next();
	SearchPage nb_group_list_next();
	SearchPage nb_group_type_list_next();
	SearchPage nb_create_group_next();
	SearchPage nb_group_num_next();	
	
	static gboolean on_window_deleteevent (GtkWidget * widget, GdkEvent * event, SearchDlg *oSearchDlg);
	static void on_back_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static void on_next_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static void on_cancel_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static void on_add_friend_send_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static void on_user_list_detail_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static gboolean on_user_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg);
	static void on_user_list_previous_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static void on_user_list_next_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static void on_user_list_all_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg);
	static gboolean on_server_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg);
	static gboolean on_group_type_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg);
	static gboolean on_group_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg);
};

#endif
