#include "s2s.h"
#include "debug.h"


S2S::S2S()
{
	router = NULL;
}

S2S::~S2S()
{
	if (router)
		delete router;
}

bool S2S::handleEvent(EVENT *ev, void *data)
{
	ICQ_ASSERT(ev->event == EV_DELIVER);

	if (!strchr(ev->packet->to, '@'))
		return false;

	PACKET *p = ev->packet;

	OutPacket out;
	out << p->to << p->from << p->online << p->cmd;
	router->sendPacket(out, p->data, p->dataLen);

	return true;
}

bool S2S::init(int module, MAPI *mapi, Profile *prof)
{
	Socket::socketRegistry = mapi->getSocketRegistry();

	uint32 ip = prof->getIP("ip", "127.0.0.1");
	int port = prof->getInteger("port", 8003);

	router = new TCPStream;
	router->connect(ip, port, 30);

	mapi->registerEvent(module, EV_DELIVER);
	return true;
}


ICQ_EXPORT ModuleListener *getModuleListener()
{
	return new S2S;
}
