/*
	writer	: Ma Su An
	E-Mail	: msa@wri.com.cn
	
	Copyright by Ma Su An.
	All rights reserved.
	Permission to use ,copy,modify,and distribute this software for
	individual use and without fee is granted with that condition:

    	Every copy of this software must have the writer's name displayed 
	on the top label.
*/

// filename: image.h
// msa 1999.1

#ifndef IMAGE_H
#define IMAGE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include <X11/cursorfont.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
 
#include "error.h"
#include "def.h"
 
#define LINELENGTH	256
#define LISTLENGTH      4096
#define XPM             1
#define GIF             2
#define COLORMOD        100
 
enum ICONTYPE { MOTIFICON,OPENWINICON };
 
typedef struct
{
        unsigned char red;
        unsigned char green;
        unsigned char blue;
}RGBColor;
 
typedef struct
{
        unsigned short int width;
        unsigned short int height;
        int colornum;
        int bg_color;
        RGBColor palette[256];
        char *data;
}ImageInfo;

typedef struct
{
        char version[6];
        unsigned short int screen_width;
        unsigned short int screen_height;
        unsigned char global_flag;
        unsigned char bg_color;
        unsigned char zero;
}GLOBALHEADER;

typedef struct
{
        unsigned char comma;
        unsigned short int image_left;
        unsigned short int image_top;
        unsigned short int image_width;
        unsigned short int image_height;
        unsigned char local_flag;
}LOCALHEADER;

//============================================================================
class Gif
{
private:
        char gifname[LINELENGTH];
        short int *CTlink;
        char *CTfirst;
        char *CTlast;
        char *OStack;
        short int reqcnt;
        short int nextlim;
        short nextcode;
        int datapoint;
        unsigned short int index;
        unsigned short int rem;
        unsigned short int remcnt;
        int interlaced;
        int headsize;
        ImageInfo info;
        int unpack_gif(ImageInfo *p_gifinfo,FILE *giffile);
        int gif_header(ImageInfo *gifinfo,FILE *giffile);
        void exchange(unsigned short int *numberp);
        void unpack_init(short int clear);
        void insert_ct(short int code,short int oldcode);
        void putx(short int code,char *data);
        short int get_code(short int req,FILE *giffile);
        void adjust(ImageInfo *gifinfo);
        void countcolor(ImageInfo *gifinfo);
public:
        Gif(char *filename=NULL);
        void vSetFileName(char *filename);
        int iGetGif(ImageInfo *imageinfo);
};

//============================================================================
class Xpm
{
private:
        char xpmname[LINELENGTH];
        ImageInfo info;
        FILE *xpmfile;
        int iFileType;

        void fillpalette(int index,int pixel);
        void getdata();
        void seek(char ch);
        int getnumber(int w);
        int char2number(int ch);
        void vGetMotifIcon();
        void vGetOpenwinIcon();

public:
        Xpm(char *filename=NULL);
        void vSetFileName(char *filename);
        int iGetXpm(ImageInfo *xpminfo);
};
 
//============================================================================
class Image
{
private: 
	char sImageFile[LINELENGTH];
        Screen *screen;
        Colormap colormap;
        XImage *ximage;
        ImageInfo imageinfo;
        int iImageType;
        Pixel piBackgroundPixel;
	int iColorLost;
	int iSearchBest(int iIndex);
public:  
        Image(char *filename);
        void vSetFileName(char *filename);
        void vSet(Screen *scrn,Colormap clrmap,Pixel bpixel);
        void vDestroyImage();
        int iWidth();
        int iHeight();
        int iGetImage(XImage * &image);
		inline int iGetColorLost(){ return(iColorLost); }
};
 
//===========================================================================
class PixmapClass
{
private: 
        Boolean bIsBitmap;
        Display *display;
        char sImageFile[LINELENGTH];
        Screen *screen;
        Colormap colormap;
        XImage *ximage;
        Pixmap pixmap;
        Pixel piBackgroundPixel;
        Pixel piForegroundPixel;
        int iWidth;
        int iHeight;
        int iX_Hot;
        int iY_Hot;
	int iColorLost;
public:  
        PixmapClass(char *filename,Boolean isbitmap=False);
        void vSetFileName(char *filename);
        void vSet(Screen *scrn,Colormap clrmap,Pixel fpixel=0,Pixel bpixel=0);
        void vCreate();
        int iGetWidth();
        int iGetHeight();
	void vSetToBeBitmap() { bIsBitmap=True; return; }
	int iGetColorLost(){ return(iColorLost); }
        Pixmap pixGetPixmap();
        ~PixmapClass();
};
 
//===========================================================================

#endif
/************************************ END ************************************/
