#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <string.h>
#include <unistd.h>

typedef unsigned char BYTE;
typedef unsigned short int WORD;

void mystrcpy(char *dest,unsigned char *src)
{
   int i,len;
   unsigned char *s;
   char *ln="\xa";
   const char *tmp;
   static char * prop[]={" "," "," ","a. ","ad. ","art. ","conj. ","int. ","n. "," "," ","num. ",
              "prep. "," ","pron. ","v. ","aux. ","vi. ","vt. ","vbl. "," ","st. ",
              "pr. ","pp. ","pl. ","ing. "," ","adj. ","adv. ","pla. ","pn. "," "};
   s=(unsigned char *)src;
   len=strlen((char*)src);
   dest[0]='\0';
   for(i=0;i<len;i++)
   {
     if(s[i]<0x20)
     {
         tmp=prop[int(src[i])];
         if(i>0) strcat(dest,ln);
         strcat(dest,tmp); //(const char *)prop[int(src[i])]);
     }
     else strncat(dest,(char *)(src+i),1);
   }
}
void markcpy(BYTE * dest,BYTE * src)
{
    while (*src)
    {
        switch (*src)
        {
            case '0':
                *dest++='C';
                break;
            case '1':
                *dest++='A';
                break;
            case '2':
                *dest++='E';
                break;
            case '3':
                *dest++='V';
                break;
            case '4':
                *dest++='Q';
                break;
            case '5':
                *dest++='J';
                break;
            case '6':
                *dest++='S';
                break;
            case '7':
                *dest++='3';
                break;
            case '8':
                *dest++='G';
                break;
            case '9':
                *dest++='K';
                break;
            case '/':
                *dest++='W';
                break;
            default:
                *dest++=*src;
                break;
        }
        src++;
    }
    *dest='\0';
}
int main(int argc,char **argv)
{
    FILE *output;
    unsigned int ItemCount=0;
    
	int fd1=open("xdict.lib",O_RDONLY);
    if(fd1==-1)
    {
        fprintf(stderr,"Input File transdic not found\r\n");
        return -2;
    }
	// get length of dicfile.
	struct stat stStat1;
	if(fstat(fd1,&stStat1)!=0)
	{
        fprintf(stderr,"Input File transdic error\r\n");
        close(fd1);
        return -3;
    }

	// mmap the file to memory
	caddr_t pFileMem1=(caddr_t)mmap((caddr_t)0,stStat1.st_size,
		PROT_READ | PROT_WRITE,MAP_PRIVATE,fd1,0);
	if(pFileMem1==MAP_FAILED)
	{
        fprintf(stderr,"mmap error !");
		return(-5);
    }

    if (!(output = fopen("xdict.dic", "wb")))
    {
        fprintf(stderr,"Unable to open outfile\r\n");
        close(fd1);
        return -2;
    }

    // begin to read items.
	caddr_t p1=pFileMem1;
    
    BYTE fakebuf = '\0';
    unsigned char *s[3];
    int count,len;
    BYTE buffer[1000];
    
	while( p1<pFileMem1+stStat1.st_size )
	{
        if ( strlen(p1) )
        {
            count = 1;  //english
            s[0] = (BYTE*)p1;
            len = strlen(p1);
            while (s[0]<(BYTE*)p1+len)  //split
            {
                if (*s[0]<=0x02)
                {
                    *s[0]='\0';
                    s[count++]=s[0]+1;
                }
                s[0]++;
            }
            s[0]=(BYTE*)p1;        //english
            ItemCount++;
            if (count==1)   //only english
            {
                fprintf(stderr,"word %s only english",s[0]);
            }
            else if (count==2)  //chinese
            {
                fwrite(s[0],sizeof(BYTE),strlen((char*)s[0])+1,output);    //english
                mystrcpy((char*)buffer,s[1]);
                fwrite(buffer,sizeof(BYTE),strlen((char*)buffer)+1,output); //chinese
                fwrite(&fakebuf,sizeof(BYTE),1,output);     //fake mark
            }
            else if (count==3)  //mark chinese
            {
                fwrite(s[0],sizeof(BYTE),strlen((char*)s[0])+1,output);    //english
                mystrcpy((char*)buffer,s[2]);
                fwrite((char *)buffer,sizeof(BYTE),strlen((char*)buffer)+1,output); //chinese
                markcpy(buffer,s[1]);
                //fwrite(s[1],sizeof(BYTE),strlen((char*)s[1])+1,output);    //mark
                fwrite((char *)buffer,sizeof(BYTE),strlen((char*)buffer)+1,output); //mark
            }
        }
        p1+=len+1;   // next item;
    }
    
    fwrite(&ItemCount,sizeof(int),1,output);
    int style = (0<<24) + (0<<16) + (1<<8) +4;
    fwrite(&style,sizeof(int),1,output);

	close(fd1);
    fclose(output);    
    return 0;
}
